VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Form1 
   Caption         =   "DemoVB for HiTi Card Printer  v1.7.0"
   ClientHeight    =   10950
   ClientLeft      =   225
   ClientTop       =   555
   ClientWidth     =   12195
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   10950
   ScaleWidth      =   12195
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox CheckTransparentCard 
      Caption         =   "Transparent Card"
      Height          =   255
      Left            =   240
      TabIndex        =   72
      Top             =   10800
      Width           =   5655
   End
   Begin VB.Frame Frame15 
      Caption         =   "Do Command:"
      Height          =   1335
      Left            =   7560
      TabIndex        =   69
      Top             =   4560
      Width           =   3255
      Begin VB.CommandButton CommandDoCommand 
         Caption         =   "Do Command"
         Height          =   375
         Left            =   240
         TabIndex        =   71
         Top             =   720
         Width           =   2655
      End
      Begin VB.ComboBox ComboCommand 
         Height          =   360
         ItemData        =   "DemoVB.frx":0000
         Left            =   240
         List            =   "DemoVB.frx":0022
         Style           =   2  'Dropdown List
         TabIndex        =   70
         Top             =   240
         Width           =   2655
      End
   End
   Begin VB.Frame Frame14 
      Caption         =   "Device Information:"
      Height          =   1335
      Left            =   7560
      TabIndex        =   66
      Top             =   3120
      Width           =   3255
      Begin VB.CommandButton CommandGetDeviceInfo 
         Caption         =   "Get Device Info"
         Height          =   375
         Left            =   240
         TabIndex        =   68
         Top             =   840
         Width           =   2655
      End
      Begin VB.ComboBox ComboDeviceInfo 
         Height          =   360
         ItemData        =   "DemoVB.frx":00F5
         Left            =   240
         List            =   "DemoVB.frx":010B
         Style           =   2  'Dropdown List
         TabIndex        =   67
         Top             =   360
         Width           =   2655
      End
   End
   Begin VB.Frame Frame8 
      Caption         =   "Card Standby Position Parameters :"
      Height          =   855
      Left            =   240
      TabIndex        =   60
      Top             =   11520
      Width           =   7215
      Begin VB.CommandButton CommandSetStandbyParameters 
         Caption         =   "Set Standby Parameters"
         Height          =   615
         Left            =   5280
         TabIndex        =   65
         Top             =   240
         Width           =   1815
      End
      Begin VB.TextBox TextStandbyTime 
         Height          =   375
         Left            =   4080
         TabIndex        =   64
         Text            =   "0"
         Top             =   360
         Width           =   1095
      End
      Begin VB.TextBox TextStandbyPos 
         Height          =   375
         Left            =   1440
         TabIndex        =   62
         Text            =   "0"
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "Time:"
         Height          =   255
         Left            =   2760
         TabIndex        =   63
         Top             =   360
         Width           =   1215
      End
      Begin VB.Label Label1 
         Alignment       =   1  'Right Justify
         Caption         =   "Position:"
         Height          =   255
         Left            =   120
         TabIndex        =   61
         Top             =   360
         Width           =   1215
      End
   End
   Begin VB.CheckBox CheckFlag6 
      Caption         =   "Move card to standby position after printing finished"
      Height          =   255
      Left            =   240
      TabIndex        =   59
      Top             =   11160
      Width           =   5415
   End
   Begin VB.Frame Frame10 
      Caption         =   "Driver Printing:"
      Height          =   5175
      Left            =   7560
      TabIndex        =   48
      Top             =   7200
      Width           =   3615
      Begin VB.CheckBox CheckFlag5 
         Caption         =   "Not print overcoat"
         Height          =   240
         Left            =   120
         TabIndex        =   73
         Top             =   4200
         Width           =   3255
      End
      Begin VB.CommandButton CommandPrintByDriver 
         Caption         =   "Print By Driver"
         Height          =   495
         Left            =   240
         TabIndex        =   57
         Top             =   4560
         Width           =   2655
      End
      Begin VB.CheckBox CheckFlag1 
         Caption         =   "Not show error message dialog"
         Height          =   240
         Left            =   120
         TabIndex        =   56
         Top             =   2760
         Width           =   3375
      End
      Begin VB.CheckBox CheckFlag2 
         Caption         =   "Wait AP process message done"
         Height          =   240
         Left            =   120
         TabIndex        =   55
         Top             =   3120
         Width           =   3375
      End
      Begin VB.CheckBox CheckFlag3 
         Caption         =   "Not popup clean message"
         Height          =   240
         Left            =   120
         TabIndex        =   54
         Top             =   3480
         Width           =   3375
      End
      Begin VB.CheckBox CheckFlag4 
         Caption         =   "Watch job printed"
         Height          =   240
         Left            =   120
         TabIndex        =   53
         Top             =   3840
         Width           =   3375
      End
      Begin VB.ComboBox ComboBackSide 
         Height          =   360
         ItemData        =   "DemoVB.frx":0182
         Left            =   240
         List            =   "DemoVB.frx":0192
         Style           =   2  'Dropdown List
         TabIndex        =   52
         Top             =   1800
         Width           =   2655
      End
      Begin VB.ComboBox ComboFrontSide 
         Height          =   360
         ItemData        =   "DemoVB.frx":01EB
         Left            =   240
         List            =   "DemoVB.frx":01FB
         Style           =   2  'Dropdown List
         TabIndex        =   51
         Top             =   1320
         Width           =   2655
      End
      Begin VB.ComboBox ComboCardType 
         Height          =   360
         ItemData        =   "DemoVB.frx":0258
         Left            =   240
         List            =   "DemoVB.frx":026E
         Style           =   2  'Dropdown List
         TabIndex        =   50
         Top             =   840
         Width           =   2655
      End
      Begin VB.ComboBox ComboRibbonType 
         Height          =   360
         ItemData        =   "DemoVB.frx":02E5
         Left            =   240
         List            =   "DemoVB.frx":02F8
         Style           =   2  'Dropdown List
         TabIndex        =   49
         Top             =   360
         Width           =   2655
      End
   End
   Begin VB.Frame Frame9 
      Caption         =   "Back 8 bits O Image (*.bmp):"
      Height          =   735
      Left            =   360
      TabIndex        =   40
      Top             =   9840
      Width           =   6975
      Begin VB.CheckBox CheckO2 
         Height          =   375
         Left            =   120
         TabIndex        =   43
         Top             =   240
         Width           =   255
      End
      Begin VB.TextBox TextO2 
         Height          =   375
         Left            =   360
         TabIndex        =   42
         Text            =   "..\1014x642_o2.bmp"
         Top             =   240
         Width           =   6015
      End
      Begin VB.CommandButton CommandO2 
         Caption         =   "..."
         Height          =   375
         Left            =   6480
         TabIndex        =   41
         Top             =   240
         Width           =   375
      End
   End
   Begin VB.Frame Frame7 
      Caption         =   "Back 24 bits BGR Image (*.bmp):"
      Height          =   735
      Left            =   360
      TabIndex        =   36
      Top             =   8160
      Width           =   6975
      Begin VB.TextBox TextBGR2 
         Height          =   345
         Left            =   360
         TabIndex        =   39
         Text            =   "..\1014x642_bgr2.bmp"
         Top             =   240
         Width           =   6015
      End
      Begin VB.CommandButton CommandBGR2 
         Caption         =   "..."
         Height          =   375
         Left            =   6480
         TabIndex        =   38
         Top             =   240
         Width           =   375
      End
      Begin VB.CheckBox CheckBGR2 
         Height          =   375
         Left            =   120
         TabIndex        =   37
         Top             =   240
         Width           =   255
      End
   End
   Begin VB.Frame Frame6 
      Caption         =   "Back 8 bits Resin K Image (*.bmp):"
      Height          =   735
      Left            =   360
      TabIndex        =   32
      Top             =   9000
      Width           =   6975
      Begin VB.TextBox TextK2 
         Height          =   345
         Left            =   360
         TabIndex        =   35
         Text            =   "..\1014x642_k2.bmp"
         Top             =   240
         Width           =   6015
      End
      Begin VB.CommandButton CommandK2 
         Caption         =   "..."
         Height          =   375
         Left            =   6480
         TabIndex        =   34
         Top             =   240
         Width           =   375
      End
      Begin VB.CheckBox CheckK2 
         Height          =   375
         Left            =   120
         TabIndex        =   33
         Top             =   240
         Width           =   255
      End
   End
   Begin VB.Frame Frame13 
      Caption         =   "Move Card To:"
      Height          =   1335
      Left            =   7560
      TabIndex        =   12
      Top             =   1680
      Width           =   3255
      Begin VB.CommandButton CommandMoveCard 
         Caption         =   "Move Card"
         Height          =   375
         Left            =   240
         TabIndex        =   27
         Top             =   840
         Width           =   2655
      End
      Begin VB.ComboBox ComboMoveCardPos 
         Height          =   360
         ItemData        =   "DemoVB.frx":031C
         Left            =   240
         List            =   "DemoVB.frx":0335
         Style           =   2  'Dropdown List
         TabIndex        =   26
         Top             =   360
         Width           =   2655
      End
   End
   Begin VB.Frame Frame12 
      Caption         =   "Connection Type:"
      Height          =   1455
      Left            =   240
      TabIndex        =   10
      Top             =   120
      Width           =   10575
      Begin VB.TextBox TextIP 
         Height          =   375
         Left            =   1800
         TabIndex        =   47
         Text            =   "192.168.1.123"
         Top             =   840
         Width           =   4215
      End
      Begin VB.PictureBox UserControl11 
         Height          =   30
         Left            =   2880
         ScaleHeight     =   30
         ScaleWidth      =   135
         TabIndex        =   46
         Top             =   960
         Width           =   135
      End
      Begin VB.OptionButton OptionConnectType 
         Caption         =   "IP address"
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   45
         Top             =   840
         Width           =   1575
      End
      Begin VB.OptionButton OptionConnectType 
         Caption         =   "Printer queue"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   44
         Top             =   360
         Value           =   -1  'True
         Width           =   1575
      End
      Begin VB.ComboBox ComboPrinter 
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   420
         Left            =   1800
         Style           =   2  'Dropdown List
         TabIndex        =   11
         Top             =   240
         Width           =   8655
      End
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   11040
      Top             =   720
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame Frame11 
      Caption         =   "Other functions:"
      Height          =   855
      Left            =   7560
      TabIndex        =   8
      Top             =   6000
      Width           =   3255
      Begin VB.CommandButton CommandCheckPrinterStatus 
         Caption         =   "Check Printer Status"
         Height          =   375
         Left            =   240
         TabIndex        =   9
         Top             =   360
         Width           =   2655
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Print:"
      Height          =   6015
      Left            =   240
      TabIndex        =   1
      Top             =   4680
      Width           =   7215
      Begin VB.ComboBox ComboOrientation 
         Height          =   360
         ItemData        =   "DemoVB.frx":03B2
         Left            =   240
         List            =   "DemoVB.frx":03BC
         Style           =   2  'Dropdown List
         TabIndex        =   58
         Top             =   360
         Width           =   3015
      End
      Begin VB.Frame Frame2 
         Caption         =   "Front 8 bits O Image (*.bmp):"
         Height          =   735
         Left            =   120
         TabIndex        =   28
         Top             =   2640
         Width           =   6975
         Begin VB.CommandButton CommandO1 
            Caption         =   "..."
            Height          =   375
            Left            =   6480
            TabIndex        =   31
            Top             =   240
            Width           =   375
         End
         Begin VB.TextBox TextO1 
            Height          =   375
            Left            =   360
            TabIndex        =   30
            Text            =   "..\1014x642_o.bmp"
            Top             =   240
            Width           =   6015
         End
         Begin VB.CheckBox CheckO1 
            Height          =   375
            Left            =   120
            TabIndex        =   29
            Top             =   240
            Value           =   1  'Checked
            Width           =   375
         End
      End
      Begin VB.CommandButton CommandDirectPrint 
         Caption         =   "Direct Print"
         Height          =   495
         Left            =   3840
         TabIndex        =   23
         Top             =   240
         Width           =   3135
      End
      Begin VB.Frame Frame5 
         Caption         =   "Front 8 bits Resin K Image (*.bmp):"
         Height          =   735
         Left            =   120
         TabIndex        =   5
         Top             =   1800
         Width           =   6975
         Begin VB.CheckBox CheckK1 
            Height          =   375
            Left            =   120
            TabIndex        =   25
            Top             =   240
            Value           =   1  'Checked
            Width           =   255
         End
         Begin VB.CommandButton CommandK1 
            Caption         =   "..."
            Height          =   375
            Left            =   6480
            TabIndex        =   7
            Top             =   240
            Width           =   375
         End
         Begin VB.TextBox TextK1 
            Height          =   345
            Left            =   360
            TabIndex        =   6
            Text            =   "..\1014x642_k.bmp"
            Top             =   240
            Width           =   6015
         End
      End
      Begin VB.Frame Frame4 
         Caption         =   "Front 24 bits BGR Image (*.bmp):"
         Height          =   735
         Left            =   120
         TabIndex        =   2
         Top             =   960
         Width           =   6975
         Begin VB.CheckBox CheckBGR1 
            Height          =   375
            Left            =   120
            TabIndex        =   24
            Top             =   240
            Value           =   1  'Checked
            Width           =   255
         End
         Begin VB.CommandButton CommandBGR1 
            Caption         =   "..."
            Height          =   375
            Left            =   6480
            TabIndex        =   4
            Top             =   240
            Width           =   375
         End
         Begin VB.TextBox TextBGR1 
            Height          =   345
            Left            =   360
            TabIndex        =   3
            Text            =   "..\1014x642_bgr.bmp"
            Top             =   240
            Width           =   6015
         End
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Magnetic Stripe Card:"
      Height          =   2895
      Left            =   240
      TabIndex        =   0
      Top             =   1680
      Width           =   7215
      Begin VB.CommandButton CommandWriteTrackData 
         Caption         =   "Write Track Data"
         Height          =   495
         Left            =   3960
         TabIndex        =   22
         Top             =   2280
         Width           =   3135
      End
      Begin VB.CommandButton CommandReadTrackData 
         Caption         =   "Read Track Data"
         Height          =   495
         Left            =   240
         TabIndex        =   21
         Top             =   2280
         Width           =   3015
      End
      Begin VB.TextBox TextT3 
         Height          =   375
         Left            =   1200
         TabIndex        =   20
         Top             =   1800
         Width           =   5895
      End
      Begin VB.TextBox TextT2 
         Height          =   375
         Left            =   1200
         TabIndex        =   19
         Top             =   1320
         Width           =   5895
      End
      Begin VB.TextBox TextT1 
         Height          =   375
         Left            =   1200
         TabIndex        =   18
         Top             =   840
         Width           =   5895
      End
      Begin VB.CheckBox CheckT3 
         Caption         =   "Track3"
         Height          =   255
         Left            =   240
         TabIndex        =   17
         Top             =   1800
         Width           =   1095
      End
      Begin VB.CheckBox CheckT2 
         Caption         =   "Track2"
         Height          =   255
         Left            =   240
         TabIndex        =   16
         Top             =   1320
         Width           =   1095
      End
      Begin VB.CheckBox CheckT1 
         Caption         =   "Track1"
         Height          =   255
         Left            =   240
         TabIndex        =   15
         Top             =   840
         Width           =   1095
      End
      Begin VB.OptionButton OptionCoer 
         Caption         =   "High Coercivity"
         Height          =   255
         Index           =   1
         Left            =   2880
         TabIndex        =   14
         Top             =   360
         Value           =   -1  'True
         Width           =   1900
      End
      Begin VB.OptionButton OptionCoer 
         Caption         =   "Low Coercivity"
         Height          =   255
         Index           =   0
         Left            =   360
         TabIndex        =   13
         Top             =   360
         Width           =   1900
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim g_nConnectType As Integer
Dim g_byCoer As Byte


Private Sub Check1_Click()

End Sub

Private Sub ComboPrinter_Click()

    Dim x As Printer
    For Each x In Printers
        If x.DeviceName = ComboPrinter.Text Then
            Set Printer = x
            Exit For
        End If
    Next

End Sub

Private Sub CommandBGR1_Click()

    CommonDialog1.DialogTitle = "Open RGB bitmap File"
    CommonDialog1.Filter = "Image(*.bmp;*.jpg)|*.bmp;*.jpg"
    CommonDialog1.FilterIndex = 1
    CommonDialog1.Flags = cdlOFNFileMustExist + cdlOFNHideReadOnly

    ' Set dialog box so an error occurs If the dialogbox is cancelled
    CommonDialog1.CancelError = True

    ' Enables error handling to catch cancel error
    On Error Resume Next
    ' display the dialog box
    CommonDialog1.ShowOpen
    If Err = 0 Then
        TextBGR1.Text = CommonDialog1.FileName
    End If

End Sub

Private Sub CommandBGR2_Click()

    CommonDialog1.DialogTitle = "Open RGB bitmap File"
    CommonDialog1.Filter = "Image(*.bmp;*.jpg)|*.bmp;*.jpg"
    CommonDialog1.FilterIndex = 1
    CommonDialog1.Flags = cdlOFNFileMustExist + cdlOFNHideReadOnly

    ' Set dialog box so an error occurs If the dialogbox is cancelled
    CommonDialog1.CancelError = True

    ' Enables error handling to catch cancel error
    On Error Resume Next
    ' display the dialog box
    CommonDialog1.ShowOpen
    If Err = 0 Then
        TextBGR2.Text = CommonDialog1.FileName
    End If

End Sub

Private Sub CommandK1_Click()

    CommonDialog1.DialogTitle = "Open K bitmap File"
    CommonDialog1.Filter = "Image(*.bmp;*.jpg)|*.bmp;*.jpg"
    CommonDialog1.FilterIndex = 1
    CommonDialog1.Flags = cdlOFNFileMustExist + cdlOFNHideReadOnly

    ' Set dialog box so an error occurs If the dialogbox is cancelled
    CommonDialog1.CancelError = True

    ' Enables error handling to catch cancel error
    On Error Resume Next
    ' display the dialog box
    CommonDialog1.ShowOpen
    If Err = 0 Then
        TextK1.Text = CommonDialog1.FileName
    End If

End Sub

Private Sub CommandK2_Click()

    CommonDialog1.DialogTitle = "Open K bitmap File"
    CommonDialog1.Filter = "Image(*.bmp;*.jpg)|*.bmp;*.jpg"
    CommonDialog1.FilterIndex = 1
    CommonDialog1.Flags = cdlOFNFileMustExist + cdlOFNHideReadOnly

    ' Set dialog box so an error occurs If the dialogbox is cancelled
    CommonDialog1.CancelError = True

    ' Enables error handling to catch cancel error
    On Error Resume Next
    ' display the dialog box
    CommonDialog1.ShowOpen
    If Err = 0 Then
        TextK2.Text = CommonDialog1.FileName
    End If

End Sub

Private Sub CommandO1_Click()

    CommonDialog1.DialogTitle = "Open O bitmap File"
    CommonDialog1.Filter = "Image(*.bmp;*.jpg)|*.bmp;*.jpg"
    CommonDialog1.FilterIndex = 1
    CommonDialog1.Flags = cdlOFNFileMustExist + cdlOFNHideReadOnly

    ' Set dialog box so an error occurs If the dialogbox is cancelled
    CommonDialog1.CancelError = True

    ' Enables error handling to catch cancel error
    On Error Resume Next
    ' display the dialog box
    CommonDialog1.ShowOpen
    If Err = 0 Then
        TextO1.Text = CommonDialog1.FileName
    End If

End Sub

Private Sub CommandO2_Click()

    CommonDialog1.DialogTitle = "Open O bitmap File"
    CommonDialog1.Filter = "Image(*.bmp;*.jpg)|*.bmp;*.jpg"
    CommonDialog1.FilterIndex = 1
    CommonDialog1.Flags = cdlOFNFileMustExist + cdlOFNHideReadOnly

    ' Set dialog box so an error occurs If the dialogbox is cancelled
    CommonDialog1.CancelError = True

    ' Enables error handling to catch cancel error
    On Error Resume Next
    ' display the dialog box
    CommonDialog1.ShowOpen
    If Err = 0 Then
        TextO2.Text = CommonDialog1.FileName
    End If

End Sub

Private Sub CommandGetDeviceInfo_Click()

    Dim dwError As Long
        
    Dim dwInfoType As Long
    Dim dwSize As Long
    Dim byteBuf(64) As Byte
    Dim longBuf(16) As Long

    Dim szString As String

    Dim dwCardPos As Long
    Dim szCardPosDesc As String

    Dim szPrinter As String

    Select Case g_nConnectType
        Case 0
            szPrinter = Printer.DeviceName
        Case 1
            szPrinter = TextIP.Text
    End Select

    dwInfoType = ComboDeviceInfo.ListIndex

    If dwInfoType = 0 Then
        dwSize = 64
        dwError = PAVO_GetDeviceInfo(szPrinter, PAVO_DEVINFO_MFG_SERIAL, byteBuf(0), dwSize)
        szString = StrConv(byteBuf, vbUnicode)
        MsgBox "Serial = " & szString, vbOKOnly, "Get Device Info"
    
    ElseIf dwInfoType = 1 Then
        dwSize = 64
        dwError = PAVO_GetDeviceInfo(szPrinter, PAVO_DEVINFO_MODEL_NAME, byteBuf(0), dwSize)
        szString = StrConv(byteBuf, vbUnicode)
        MsgBox "Model = " & szString, vbOKOnly, "Get Device Info"

    ElseIf dwInfoType = 2 Then
        dwSize = 64
        dwError = PAVO_GetDeviceInfo(szPrinter, PAVO_DEVINFO_FIRMWARE_VERSION, byteBuf(0), dwSize)
        szString = StrConv(byteBuf, vbUnicode)
        MsgBox "FW version = " & szString, vbOKOnly, "Get Device Info"

    ElseIf dwInfoType = 3 Then
        dwSize = 64
        dwError = PAVO_GetDeviceInfo(szPrinter, PAVO_DEVINFO_RIBBON_INFO, longBuf(0), dwSize)
        MsgBox "Ribbon Type = " & vbLf & vbLf & longBuf(0) & "Remain ribbon = " & longBuf(1), vbOKOnly, "Get Device Info"

    ElseIf dwInfoType = 4 Then
        dwSize = 64
        dwError = PAVO_GetDeviceInfo(szPrinter, PAVO_DEVINFO_PRINT_COUNT, longBuf(0), dwSize)
        MsgBox "Printed card = " & longBuf(0), vbOKOnly, "Get Device Info"

    ElseIf dwInfoType = 5 Then
        dwSize = 4
        dwError = PAVO_GetDeviceInfo(szPrinter, PAVO_DEVINFO_CARD_POSITION, dwCardPos, dwSize)

        Select Case dwCardPos
            Case 0
                    szCardPosDesc = "Out of printer"
            Case 1
                    szCardPosDesc = "Start printing position"
            Case 2
                    szCardPosDesc = "Mag out position"
            Case 3
                    szCardPosDesc = "Mag in position"
            Case 4
                    szCardPosDesc = "Contact encoder position"
            Case 5
                    szCardPosDesc = "Contactless encoder position"
            Case 6
                    szCardPosDesc = "Flipper position"
            Case 7
                    szCardPosDesc = "Card jam"
            Case 8
                    szCardPosDesc = "Standby position"
        End Select

        MsgBox "Card position = " & dwCardPos & vbLf & vbLf & szCardPosDesc, vbOKOnly, "Get Device Info"
    End If

End Sub


Private Sub CommandDoCommand_Click()
    Dim dwError As Long
    Dim nOption As Long
    Dim dwCommand As Long
    Dim dwStatus As Long

    Dim szPrinter As String

    Select Case g_nConnectType
        Case 0
            szPrinter = Printer.DeviceName
        Case 1
            szPrinter = TextIP.Text
    End Select

    nOption = ComboCommand.ListIndex

    Select Case nOption
        Case 0
            dwCommand = PAVO_COMMAND_RESET_PRINTER
        Case 1
            dwCommand = PAVO_COMMAND_CLEAN_CARD_PATH
        Case 2
            dwCommand = PAVO_COMMAND_RESET_PRINT_COUNT
        Case 3
            dwCommand = PAVO_COMMAND_FLIP_CARD
        Case 4
            dwCommand = PAVO_COMMAND_AUTO_FEED_FROM_FLIPPER_ON
        Case 5
            dwCommand = PAVO_COMMAND_AUTO_FEED_FROM_FLIPPER_OFF
        Case 6
            dwCommand = PAVO_COMMAND_RESET_PRINTER_CLEAR_JAM
        Case 7
            dwCommand = PAVO_COMMAND_TIGHTEN_RIBBON
        Case 8
            dwCommand = PAVO_COMMAND_ERASE_CARD_BY_DRIVER
        Case 9
            dwCommand = PAVO_COMMAND_DETECT_CARD_EMPTY
    End Select

    dwError = PAVO_DoCommand(szPrinter, dwCommand)

    If dwError = PAVO_DS_OFFLINE Then 'printer is not connected

        MsgBox "Printer is not connected.", vbCritical, "Error"

    ElseIf dwError <> 0 Then

        MsgBox "Error happened: " & dwError, vbCritical, "Error"

    Else

        If dwCommand <> PAVO_COMMAND_CLEAN_CARD_PATH And dwCommand <> PAVO_COMMAND_DETECT_CARD_EMPTY Then
            MsgBox "PAVO_DoCommand() OK.", vbInformation, "DemoVB"
        End If
    End If

    'wait clean finish
    If dwCommand = PAVO_COMMAND_CLEAN_CARD_PATH And dwError = 0 Then

        dwStatus = PAVO_DS_BUSY
        While dwStatus = PAVO_DS_BUSY
            dwRet = PAVO_CheckPrinterStatus(szPrinter, dwStatus)
        
            If dwStatus = PAVO_DS_BUSY Then
                Sleep (1000)
            End If
        Wend
        
        If dwStatus <> 0 And dwStatus <> PAVO_DS_PRINTING Then
            MsgBox "Clean Card Path Error happened: " & Hex$(dwStatus), vbCritical, "Clean Card Path"
        Else
            MsgBox "Clean Card Path OK.", vbInformation, "Clean Card Path"
        End If
    'Detect card empty
    ElseIf dwCommand = PAVO_COMMAND_DETECT_CARD_EMPTY And dwError = 0 Then

        dwStatus = PAVO_DS_BUSY
        While dwStatus = PAVO_DS_BUSY
            dwRet = PAVO_CheckPrinterStatus(szPrinter, dwStatus)
        
            If dwStatus = PAVO_DS_BUSY Then
                Sleep (1000)
            End If
        Wend
        
        If dwStatus <> 0 And dwStatus <> PAVO_DS_PRINTING Then
            MsgBox "Detect Card Empty return: " & Hex$(dwStatus), vbCritical, "Detect Card Empty"
        Else
            MsgBox "Card is not empty.", vbInformation, "Detect Card Empty"
        End If
    End If

End Sub

Private Sub CommandCheckPrinterStatus_Click()
    Dim dwStatus As Long
    Dim dwError As Long

    Dim szPrinter As String

    Select Case g_nConnectType
        Case 0
            szPrinter = Printer.DeviceName
        Case 1
            szPrinter = TextIP.Text
    End Select

    dwError = PAVO_CheckPrinterStatus(szPrinter, dwStatus)
    If dwError = PAVO_DS_OFFLINE Then 'printer is not connected

        MsgBox "Printer = " & szPrinter & vbLf & vbLf & "Printer is not connected.", vbCritical, "CheckPrinterStatus"

    ElseIf dwError <> 0 Then

        MsgBox "Error happened: " & dwError, vbCritical, "Error"

    Else

        If dwStatus = PAVO_DS_BUSY Then
            MsgBox "Printer is busy.", vbInformation, "CheckPrinterStatus"
        ElseIf dwStatus = PAVO_DS_PRINTING Then
            MsgBox "Printer is printing.", vbInformation, "CheckPrinterStatus"
        Else
            MsgBox "Printer = " & szPrinter & vbLf & vbLf & "dwStatus = &H" & Hex$(dwStatus), vbCritical, "CheckPrinterStatus"
        End If

    End If

End Sub

Private Sub CommandMoveCard_Click()

    Dim dwError As Long
    Dim dwPos As Long

    Dim szPrinter As String

    Select Case g_nConnectType
        Case 0
            szPrinter = Printer.DeviceName
        Case 1
            szPrinter = TextIP.Text
    End Select

    Select Case ComboMoveCardPos.ListIndex
    Case 0
        dwPos = MOVE_CARD_TO_IC_ENCODER
    Case 1
        dwPos = MOVE_CARD_TO_RFID_ENCODER
    Case 2
        dwPos = MOVE_CARD_TO_HOPPER
    Case 3
        dwPos = MOVE_CARD_TO_REJECT_BOX
    Case 4
        dwPos = MOVE_CARD_TO_FLIPPER
    Case 5
        dwPos = MOVE_CARD_TO_PRINT_FROM_FLIPPER
    Case 6
        dwPos = MOVE_CARD_TO_STANDBY_POSITION
    Case Else
        dwPos = 0
    End Select

    If dwPos = 0 Then
        Exit Sub
    End If

    dwError = PAVO_MoveCard(szPrinter, dwPos)
    If dwError = PAVO_DS_OFFLINE Then 'printer is not connected

        MsgBox "Printer is not connected.", vbCritical, "Error"

    ElseIf dwError <> 0 Then

        MsgBox "Error happened: " & dwError, vbCritical, "Error"

    Else

        MsgBox "Move Card OK.", vbInformation, "DemoVB"

    End If

End Sub

Private Sub CommandDirectPrint_Click()
    Dim dwStatus As Long
    Dim dwError As Long

    Dim JobPara As HITI_CARD_PRINT_PARAMETER
    Dim HeatEnergy As HITI_HEATING_ENERGY

    Dim dwRet As Long
    Dim dwFlags As Long

    Dim ImgColor1 As New StdPicture
    Dim BmpColor1 As BITMAP
    Dim ImgK1 As New StdPicture
    Dim BmpK1 As BITMAP
    Dim ImgO1 As New StdPicture
    Dim BmpO1 As BITMAP

    Dim ImgColor2 As New StdPicture
    Dim BmpColor2 As BITMAP
    Dim ImgK2 As New StdPicture
    Dim BmpK2 As BITMAP
    Dim ImgO2 As New StdPicture
    Dim BmpO2 As BITMAP

    Dim szPrinter As String

    Select Case g_nConnectType
        Case 0
            szPrinter = Printer.DeviceName
        Case 1
            szPrinter = TextIP.Text
    End Select

    'load image from file
    ZeroMemory BmpColor1, Len(BITMAP)
    ZeroMemory BmpK1, Len(BITMAP)
    ZeroMemory BmpO1, Len(BITMAP)
    ZeroMemory BmpColor2, Len(BITMAP)
    ZeroMemory BmpK2, Len(BITMAP)
    ZeroMemory BmpO2, Len(BITMAP)

    If CheckBGR1.Value And TextBGR1.Text <> "" Then
        Set ImgColor1 = LoadPicture(TextBGR1.Text)
        GetObject ImgColor1.Handle, Len(BmpColor1), BmpColor1
    End If

    If CheckK1.Value And TextK1.Text <> "" Then
        Set ImgK1 = LoadPicture(TextK1.Text)
        GetObject ImgK1.Handle, Len(BmpK1), BmpK1
    End If

    If CheckO1.Value And TextO1.Text <> "" Then
        Set ImgO1 = LoadPicture(TextO1.Text)
        GetObject ImgO1.Handle, Len(BmpO1), BmpO1
    End If

    If CheckBGR2.Value And TextBGR2.Text <> "" Then
        Set ImgColor2 = LoadPicture(TextBGR2.Text)
        GetObject ImgColor2.Handle, Len(BmpColor2), BmpColor2
    End If

    If CheckK2.Value And TextK2.Text <> "" Then
        Set ImgK2 = LoadPicture(TextK2.Text)
        GetObject ImgK2.Handle, Len(BmpK2), BmpK2
    End If

    If CheckO2.Value And TextO2.Text <> "" Then
        Set ImgO2 = LoadPicture(TextO2.Text)
        GetObject ImgO2.Handle, Len(BmpO2), BmpO2
    End If

    If CheckFlag6.Value Then
        dwFlags = dwFlags Or PAVO_FLAG_MOVE_CARD_TO_STANDBY_AFTER_PRINTED
    End If


    'fill HITI_CARD_PRINT_PARAMETER
    ZeroMemory JobPara, Len(HITI_CARD_PRINT_PARAMETER)
    JobPara.dwSize = Len(HITI_CARD_PRINT_PARAMETER)
    JobPara.byOrientation = ComboOrientation.ListIndex + 1
    JobPara.byCardThickness = 2    '0=0.3mm;1=0.5mm;2=0.8mm;3=1.0mm
    JobPara.dwFlags = dwFlags

    If CheckTransparentCard.Value Then
        JobPara.byTransparentCard = 1
    End If

    'for portrait printing, all the data has 642 pixels width and 1014 pixels height
    'for landscape printing, all the data has 1014 pixels width and 642 pixels height
    'if the data pointer is null, than the plane will not be printed.
    If BmpColor1.bmBits Then
        JobPara.lpFrontBGR = VarPtr(BmpColor1)
    End If

    If BmpK1.bmBits Then
        JobPara.lpFrontK = VarPtr(BmpK1)
    End If

    If BmpO1.bmBits Then
        JobPara.lpFrontO = VarPtr(BmpO1)
    End If

    If BmpColor2.bmBits Then
        JobPara.lpBackBGR = VarPtr(BmpColor2)
    End If

    If BmpK2.bmBits Then
        JobPara.lpBackK = VarPtr(BmpK2)
    End If

    If BmpO2.bmBits Then
        JobPara.lpBackO = VarPtr(BmpO2)
    End If

    'fill HITI_HEATING_ENERGY
    ZeroMemory HeatEnergy, Len(HITI_HEATING_ENERGY)

    'Heating Energy adjustment, value range of following fields are -127 ~ 127
    'same as driver UI Heating Energy tab
    'for ribbon YMCKO
    HeatEnergy.chFrontDenYMC = 0
    HeatEnergy.chFrontDenK = 0
    HeatEnergy.chFrontDenO = 0

    HeatEnergy.chBackDenYMC = 0
    HeatEnergy.chBackDenK = 0
    HeatEnergy.chBackDenO = 0

    HeatEnergy.chFrontSenYMC = 0
    HeatEnergy.chFrontSenK = 0
    HeatEnergy.chFrontSenO = 0

    HeatEnergy.chBackSenYMC = 0
    HeatEnergy.chBackSenK = 0
    HeatEnergy.chBackSenO = 0

    'for ribbon K
    HeatEnergy.chFrontDenResinK = 0
    HeatEnergy.chBackDenResinK = 0
    HeatEnergy.chFrontSenResinK = 0
    HeatEnergy.chBackSenResinK = 0

    '2. check if there is error
    dwStatus = PAVO_DS_BUSY
    While dwStatus = PAVO_DS_BUSY
        dwRet = PAVO_CheckPrinterStatus(szPrinter, dwStatus)

        If dwStatus = PAVO_DS_BUSY Then
            Sleep (1000)
        End If
    Wend

    If dwStatus <> 0 And dwStatus <> PAVO_DS_PRINTING Then
        MsgBox "Printer = " & szPrinter & vbLf & vbLf & "dwStatus = &H" & Hex$(dwStatus), vbCritical, "CommandDirectPrint"
        Exit Sub
    End If

    '3. Send print data to printer memory.
    '   If printer is at ready state, it will perform printing immediately.
    dwRet = PAVO_PrintOneCard(szPrinter, JobPara, HeatEnergy, 0)

    'if any error happened
    If dwRet <> 0 Then
        MsgBox "Error happened after PAVO_PrintOneCard() => &H" & Hex$(dwRet), vbCritical, "CommandDirectPrint"
        Exit Sub
    End If

    '4. Optional
    'If you need to do another encoding, please wait printer to print card completely.
    Sleep (5000) 'wait for printer firmware to process data
    dwStatus = PAVO_DS_BUSY
    While dwStatus = PAVO_DS_BUSY Or dwStatus = PAVO_DS_PRINTING
        dwRet = PAVO_CheckPrinterStatus(szPrinter, dwStatus)

        If dwStatus = PAVO_DS_BUSY Or dwStatus = PAVO_DS_PRINTING Then
            Sleep (1000)
        End If
    Wend

    If dwStatus <> 0 And dwStatus <> PAVO_DS_BUSY And dwStatus <> PAVO_DS_PRINTING Then
        MsgBox "Printer = " & szPrinter & vbLf & vbLf & "dwStatus = &H" & Hex$(dwStatus), vbCritical, "CommandDirectPrint"
        Exit Sub
    Else
        MsgBox "PAVO_PrintOneCard() return success.", vbOKOnly, "CommandDirectPrint"
    End If

End Sub

Private Sub CommandPrintByDriver_Click()

    Dim nRet As Long
    Dim dwError As Long
    Dim myDocInfo As DOCINFO

    Dim BmpInfo As BITMAPINFO

    Dim ImgColor1 As New StdPicture
    Dim BmpColor1 As BITMAP
    Dim ImgK1 As New StdPicture
    Dim BmpK1 As BITMAP

    Dim ImgColor2 As New StdPicture
    Dim BmpColor2 As BITMAP
    Dim ImgK2 As New StdPicture
    Dim BmpK2 As BITMAP

    Dim nDstW As Long
    Dim nDstH As Long
    Dim nSrcW As Long
    Dim nSrcH As Long
    Dim dwSize As Long

    Dim JobProp As PAVO_JOB_PROPERTY

    Dim bColorFront As Boolean
    Dim bKFront As Boolean
    Dim bColorBack As Boolean
    Dim bKBack As Boolean

    Dim nRibbonType As Long
    Dim dwFlags As Long

    Dim iBKMode As Integer

    If g_nConnectType <> 0 Then
        MsgBox "Please select printer queue.", vbExclamation, "Print By Driver"
        Exit Sub
    End If

    'ribbon type
    Select Case ComboRibbonType.ListIndex
        Case 0
            nRibbonType = PAVO_RIBBON_TYPE_YMCKO
        Case 1
            nRibbonType = PAVO_RIBBON_TYPE_K
        Case 2
            nRibbonType = PAVO_RIBBON_TYPE_HALF_YMCKO
        Case 3
            nRibbonType = PAVO_RIBBON_TYPE_YMCKOK
        Case 4
            nRibbonType = PAVO_RIBBON_TYPE_KO
    End Select

    'front side
    If ComboFrontSide.ListIndex <> 0 Then
        If CheckBGR1.Value Then
            bColorFront = True
        End If
        
        If CheckK1.Value Then
            bKFront = True
        End If
    End If
    
    'back side
    If ComboBackSide.ListIndex <> 0 Then
        If CheckBGR2.Value Then
            bColorBack = True
        End If
        If CheckK2.Value Then
            bKBack = True
        End If
    End If
    
    'flags
    If CheckFlag1.Value Then
        dwFlags = dwFlags Or PAVO_FLAG_NOT_SHOW_ERROR_MSG_DLG
    End If
    If CheckFlag2.Value Then
        dwFlags = dwFlags Or PAVO_FLAG_WAIT_MSG_DONE
    End If
    If CheckFlag3.Value Then
        dwFlags = dwFlags Or PAVO_FLAG_NOT_SHOW_CLEAN_MSG
    End If
    If CheckFlag4.Value Then
        dwFlags = dwFlags Or PAVO_FLAG_WATCH_JOB_PRINTED
    End If
    If CheckFlag5.Value Then
        dwFlags = dwFlags Or PAVO_FLAG_NO_OVERCOATING
    End If
    If CheckFlag6.Value Then
        dwFlags = dwFlags Or PAVO_FLAG_MOVE_CARD_TO_STANDBY_AFTER_PRINTED
    End If

    'load image from file
    If bColorFront And CheckBGR1 And TextBGR1.Text <> "" Then
        Set ImgColor1 = LoadPicture(TextBGR1.Text)
        GetObject ImgColor1.Handle, Len(BmpColor1), BmpColor1
    End If

    If bKFront And CheckK1 And TextK1.Text <> "" Then
        Set ImgK1 = LoadPicture(TextK1.Text)
        GetObject ImgK1.Handle, Len(BmpK1), BmpK1
    End If

    If bColorBack And CheckBGR2 And TextBGR2.Text <> "" Then
        Set ImgColor2 = LoadPicture(TextBGR2.Text)
        GetObject ImgColor2.Handle, Len(BmpColor2), BmpColor2
    End If

    If bKBack And CheckK2 And TextK2.Text <> "" Then
        Set ImgK2 = LoadPicture(TextK2.Text)
        GetObject ImgK2.Handle, Len(BmpK2), BmpK2
    End If


    '+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    '1. If need to change the settings, add codes here
    JobProp.dwSize = 80
    JobProp.hParentWnd = Me.hWnd
    JobProp.dwCardType = ComboCardType.ListIndex
    JobProp.byRibbonType = nRibbonType
    JobProp.shOrientation = ComboOrientation.ListIndex + 1
    JobProp.shCopies = 1
    JobProp.dwFlags = dwFlags

    If CheckTransparentCard.Value Then
        JobProp.byTransparentCard = 1
    End If

    'It is not necessary to change all fields value.
    'You can set almost fields by driver UI.
    'You should just set the flag of the field that you want to change its value.
    JobProp.dwFieldFlag = FF_CARD_TYPE Or FF_FLAGS Or FF_PARENT_HWND Or FF_ORIENTATION Or FF_COPIES Or FF_DUPLEX Or FF_RIBBON_TYPE Or FF_PRINT_COLOR Or FF_TRANSPARENT_AND_FLIP

'   'If you want to use your own job ID, set it to dwCustomIndex.
'   JobProp.dwCustomIndex = 1234
'   JobProp.dwFieldFlag = JobProp.dwFieldFlag Or FF_CUSTOM_INDEX


    'PAVO_JOB_PROPERTY.byDuplex
    If bColorFront Or bKFront Then
        JobProp.byDuplex = PAVO_DUPLEX_PRINT_FRONT_SIDE
    End If

    If bColorBack Or bKBack Then
        JobProp.byDuplex = JobProp.byDuplex Or PAVO_DUPLEX_PRINT_BACK_SIDE
    End If

    'PAVO_JOB_PROPERTY.byPrintColor
    If bColorFront Then
        JobProp.byPrintColor = 1      'front side color image
    End If

    If bColorBack Then
        JobProp.byPrintColor = JobProp.byPrintColor + 2   'back side color image
    End If

    'PAVO_JOB_PROPERTY.dwDataFlag
    If bKFront And BmpK1.bmBits Then
        JobProp.dwFieldFlag = JobProp.dwFieldFlag Or FF_DATA_FLAG
        JobProp.dwDataFlag = JobProp.dwDataFlag Or PAVO_DATAFLAG_RESIN_FRONT
    End If

    If bKBack And BmpK2.bmBits Then
        JobProp.dwFieldFlag = JobProp.dwFieldFlag Or FF_DATA_FLAG
        JobProp.dwDataFlag = JobProp.dwDataFlag Or PAVO_DATAFLAG_RESIN_BACK
    End If


'    'If you want driver to apply dither effect, then YMC will not be printed.
'    JobProp.dwFieldFlag = JobProp.dwFieldFlag + FF_DITHER_K
'    JobProp.byPrintColor = 0
'    If bDuplexFront Then
'        JobProp.byDitherK = 1
'    End If
'    If bDuplexBack Then
'        JobProp.byDitherK = JobProp.byDitherK + 2
'    End If


    '3. Optional. Apply the job setting into the DC.
    '   Please notice that this function will get the printer's current setting,
    '   and then combine the settings value with JobProp values.
    '   If you want to use the printer's current settings set by driver UI. Please skip this function.

    dwError = PAVO_ApplyJobSetting(Printer.DeviceName, Printer.hDC, 0, JobProp)
    If dwError <> 0 Then
        Exit Sub
    End If

    '4. StartDoc
    myDocInfo.cbSize = 20   'Len(myDocInfo)
    myDocInfo.lpszDocName = "DemoVB6 job"

    nJobId = StartDoc(Printer.hDC, myDocInfo)

    '--------------------------------------------------------------------------
    'front side part
    '--------------------------------------------------------------------------
    If bColorFront Or bKFront Then

        '5. StartPage
        StartPage (Printer.hDC)

        '6.a Send resin K data before any drawing GDIs.
        '    Please notice that the black data must be a 8-bits gray data with size 642x1014 for portrait or 1014x642 for landscape.
        '    And the start position must be at (0, 0).
        '    And please notice that the pixel value 0x00 will print out blank, and 0xFF will print out black.
        If bKFront And BmpK1.bmBits Then
            dwError = PAVO_SetExtraDataToHDC(Printer.hDC, PAVO_DATA_RESIN_FRONT, 0, 0, BmpK1)
        End If

        '6.b Draw anything you want on page between StartPage and EndPage
        If bColorFront Then
            If BmpColor1.bmBits Then
                nDstW = Printer.ScaleX(Printer.Width, vbTwips, vbPixels)
                nDstH = Printer.ScaleY(Printer.Height, vbTwips, vbPixels)

                BmpInfo.bmiHeader.biSize = Len(BmpInfo.bmiHeader)
                BmpInfo.bmiHeader.biWidth = BmpColor1.bmWidth
                BmpInfo.bmiHeader.biHeight = BmpColor1.bmHeight
                BmpInfo.bmiHeader.biPlanes = BmpColor1.bmPlanes
                BmpInfo.bmiHeader.biBitCount = BmpColor1.bmBitsPixel
                BmpInfo.bmiHeader.biCompression = BI_RGB

                nRet = StretchDIBits(Printer.hDC, 0, 0, nDstW, nDstH, 0, 0, BmpColor1.bmWidth, BmpColor1.bmHeight, BmpColor1.bmBits, BmpInfo, DIB_RGB_COLORS, SRCCOPY)
                dwError = GetLastError()
            End If

            Printer.Font.SIZE = 12
            Printer.Font.Name = "Arial"
            Printer.ForeColor = RGB(255, 0, 0) ' For Text in Red Color

            iBKMode = SetBkMode(Printer.hDC, TRANSPARENT)

            dwError = TextOut(Printer.hDC, 100, 150, "Front Side", 10)

            iBKMode = SetBkMode(Printer.hDC, OPAQUE)
            Printer.ForeColor = RGB(0, 0, 0) ' For Text in Black Color

        End If

        '7. EndPage
        EndPage (Printer.hDC)

    End If

    'print back side
    '--------------------------------------------------------------------------
    If bColorBack Or bKBack Then

        '5. StartPage
        StartPage (Printer.hDC)

        '6.a Send resin K data before any drawing GDIs.
        '    Please notice that the black data must be a 8-bits gray data with size 642x1014 for portrait or 1014x642 for landscape.
        '    And the start position must be at (0, 0).
        '    And please notice that the pixel value 0x00 will print out blank, and 0xFF will print out black.
        If bKBack And BmpK2.bmBits Then
            dwError = PAVO_SetExtraDataToHDC(Printer.hDC, PAVO_DATA_RESIN_BACK, 0, 0, BmpK2)
        End If

        '6.b Draw anything you want on page between StartPage and EndPage
        If bColorBack Then

            If BmpColor2.bmBits Then
                nDstW = Printer.ScaleX(Printer.Width, vbTwips, vbPixels)
                nDstH = Printer.ScaleY(Printer.Height, vbTwips, vbPixels)

                BmpInfo.bmiHeader.biSize = Len(BmpInfo.bmiHeader)
                BmpInfo.bmiHeader.biWidth = BmpColor2.bmWidth
                BmpInfo.bmiHeader.biHeight = BmpColor2.bmHeight
                BmpInfo.bmiHeader.biPlanes = BmpColor2.bmPlanes
                BmpInfo.bmiHeader.biBitCount = BmpColor2.bmBitsPixel
                BmpInfo.bmiHeader.biCompression = BI_RGB

                nRet = StretchDIBits(Printer.hDC, 0, 0, nDstW, nDstH, 0, 0, BmpColor2.bmWidth, BmpColor2.bmHeight, BmpColor2.bmBits, BmpInfo, DIB_RGB_COLORS, SRCCOPY)
                dwError = GetLastError()
            End If

            Printer.FillStyle = vbFSTransparent

            nRet = TextOut(Printer.hDC, 100, 300, "Back Side", 9)

        End If

        '7. EndPage
        EndPage (Printer.hDC)

    End If

    '8. 8. If job done, set end of the job
    nRet = EndDoc(Printer.hDC)

End Sub


Private Sub CommandReadTrackData_Click()

    Dim dwError As Long
    Dim TrackDataIn As MAG_TRACK_DATA2

    Dim szPrinter As String

    Select Case g_nConnectType
        Case 0
            szPrinter = Printer.DeviceName
        Case 1
            szPrinter = TextIP.Text
    End Select

    TrackDataIn.byTrackFlag = 0
    TrackDataIn.byCoercivity = g_byCoer

    If CheckT1.Value Then
        TrackDataIn.byTrackFlag = 1
    End If

    If CheckT2.Value Then
        TrackDataIn.byTrackFlag = TrackDataIn.byTrackFlag + 2
    End If

    If CheckT3.Value Then
        TrackDataIn.byTrackFlag = TrackDataIn.byTrackFlag + 4
    End If

    'read track data to card
    dwError = PAVO_ReadMagTrackData(szPrinter, 0, TrackDataIn)

    If dwError <> 0 Then
        MsgBox "PAVO_ReadMagTrackData() error happened. " & dwError, vbCritical, "ReadMagTrackData"
    Else

        TextT1.Text = TrackDataIn.szTrack1
        TextT2.Text = TrackDataIn.szTrack2
        TextT3.Text = TrackDataIn.szTrack3

        MsgBox "PAVO_ReadMagTrackData() success.", vbInformation, "ReadMagTrackData"
    End If


End Sub

Private Sub CommandSetStandbyParameters_Click()
    Dim dwError As Long

    Dim szPrinter As String

    Dim byStandbyPos As Byte
    Dim byStandbyTime As Byte

    Select Case g_nConnectType
        Case 0
            szPrinter = Printer.DeviceName
        Case 1
            szPrinter = TextIP.Text
    End Select

    byStandbyPos = Val(TextStandbyPos.Text)
    byStandbyTime = Val(TextStandbyTime.Text)
    
    dwError = PAVO_SetStandbyParameters(szPrinter, byStandbyPos, byStandbyTime)
    If dwError = PAVO_DS_OFFLINE Then 'printer is not connected

        MsgBox "Printer is not connected.", vbCritical, "Error"

    ElseIf dwError <> 0 Then

        MsgBox "Error happened: " & dwError, vbCritical, "Error"

    Else

        MsgBox "PAVO_SetStandbyParameters() OK.", vbInformation, "DemoVB"

    End If

End Sub

Private Sub CommandWriteTrackData_Click()

    Dim dwError As Long
    Dim TrackDataOut As MAG_TRACK_DATA2

    Dim szPrinter As String

    Select Case g_nConnectType
        Case 0
            szPrinter = Printer.DeviceName
        Case 1
            szPrinter = TextIP.Text
    End Select

    '1. set track data to encode
    TrackDataOut.byTrackFlag = 0
    TrackDataOut.byCoercivity = g_byCoer

    'The track data are not checked by this sample. Please check it by your own code.
    If CheckT1.Value Then
        TrackDataOut.byTrackFlag = 1
        lstrcpyn TrackDataOut.szTrack1, TextT1.Text, Len(TextT1.Text) + 1
    End If

    If CheckT2.Value Then
        TrackDataOut.byTrackFlag = TrackDataOut.byTrackFlag + 2
        lstrcpyn TrackDataOut.szTrack2, TextT2.Text, Len(TextT2.Text) + 1
    End If

    If CheckT3.Value Then
        TrackDataOut.byTrackFlag = TrackDataOut.byTrackFlag + 4
        lstrcpyn TrackDataOut.szTrack3, TextT3.Text, Len(TextT3.Text) + 1
    End If

    '2. encode track data to card
    dwError = PAVO_WriteMagTrackData(szPrinter, 0, TrackDataOut)

    If dwError <> 0 Then
        MsgBox "PAVO_WriteMagTrackData() error happened. " & dwError, vbCritical, "WriteMagTrackData"
    Else
        MsgBox "PAVO_WriteMagTrackData() success.", vbInformation, "WriteMagTrackData"
    End If

End Sub

Private Sub Form_Load()

    Dim x As Printer
    For Each x In Printers
        ComboPrinter.AddItem (x.DeviceName)
    Next

    If ComboPrinter.ListCount > 0 Then
        ComboPrinter.ListIndex = 0
    End If

    g_nConnectType = 0
    g_byCoer = 1

    ComboRibbonType.ListIndex = 0
    ComboCardType.ListIndex = 0
    ComboFrontSide.ListIndex = 3
    ComboBackSide.ListIndex = 0
    ComboOrientation.ListIndex = 1

    g_lWndProcOrg = SetWindowLong(Me.hWnd, GWL_WNDPROC, AddressOf WindowProc)

End Sub


Private Sub Form_Unload(Cancel As Integer)
    SetWindowLong Me.hWnd, GWL_WNDPROC, g_lWndProcOrg
End Sub

Private Sub OptionCoer_Click(Index As Integer)
    g_byCoer = Index
End Sub

Private Sub OptionConnectType_Click(Index As Integer)
    g_nConnectType = Index
End Sub


